#
# This script creates a window which prompts for the name of a file that was
# used to download data from an MS Exchange Server. This file is then processed
# and a new file is created that contains the data in such a manner that it can
# be loaded into the AltaVista Directory using the load applet.
#
# First source the conv.tcl script so we define the avdconv procedure so that
# all the real work will be done when the user presses the OK button.
#

source ..\\Library\\conv.tcl

#
# Now create the window that will get the information form the user.
#
wm title . "AltaVista Directory Load File Generator"
wm iconname . "AltaVista Directory Load File Generator"
focus -force .

frame .left -height 10c -width 20c
frame .rigth -height 10c -width 20c
frame .questions -height 10c -width 40c
frame .buttons -height 2c -width 5c

image create photo avdimage -file ..\\Library\\TclAvdir.gif
label .avd -image avdimage
label .label1 -text "Input File Name:"
label .label2 -text "Output File Name:"

entry .en1 -width 40 -relief sunken -bd 3 -textvariable filein
entry .en2 -width 40 -relief sunken -bd 3 -textvariable fileout

button .ok -text OK -command OK
# button .help -text Help -command HELP
button .cancel -text Cancel -command "destroy ." 

pack .label1 .label2 -side top -anchor w -in .left -pady 3
pack .en1 .en2 -side top -fill x -in .rigth

pack .left .rigth -side left -in .questions
# pack .ok .help .cancel -side left -in .buttons -padx 10 -pady 10 -expand 1
pack .ok .cancel -side left -in .buttons -padx 10 -pady 10 -expand 1

pack  .avd .questions .buttons -side top -pady 3 -padx 5

bind .cancel <Return> { destroy .}
bind .ok <Return> { OK}
# bind .help <Return> { HELP}

focus .ok

set envlist [array name env]
if {[lsearch -exact $envlist HOMEPATH] == -1} {
	set filein "\\"
} else {
	set filein $env(HOMEPATH)
}
unset envlist
#
# The actions routines/procedures which are neaded when the OK button 
# is pressed.
#

proc OK {} {

	global filein fileout

	if {$filein == ""} {
		# 
		# There is no input file name specified - create an error box
		#
		report_win " No input filename Supplied.\n Please Supply one."   	
		uplevel 0 "return 0"
	}

	if {$fileout == ""} {
		# 
		# There is no output file name specified - create an error box
		#
		report_win " No output filename Supplied.\n Please Supply one."   	
		uplevel 0 "return 0"
	}
	
   	#
   	# Do the stuff...
   	#
	if {![file exists $filein]} {
		#
		# File does not exist.
		#
		report_win "The specified input file name\n does not exist."
		uplevel 0 "return 0"
	}
	catch {avdconv } status
	catch {avdclose}
	if {$status != 1} {
		#
		# An error occured during the load.
		#
		report_win $status
	} else {
		report_win "      Conversion completed.\n \nPlease check output file to see\n if any problems occured."
	}
}

proc report_win {text} {
	#
	# Create a window which displays the text supplied.
	#
	catch { unset but}
	toplevel .dia -class dialog
	frame .dia.frame

	wm title .dia "AltaVista Directory Load File Generator - Report"
	wm iconname .dia "AltaVista Directory Load File Generator - Report"
	label .dia.bit -bitmap error
	message .dia.msg -width 6c -text $text 
	button .dia.but -text "OK" -command "set but 1" 
	pack .dia.bit .dia.msg .dia.but -side top -ipadx 3m -in .dia.frame
	pack .dia.frame 
	bind .dia.but <Return> { set but 1}
	#
	# Now bring to to the top and highlight the error...
	#
	set oldfocus [focus]
	grab set .dia
	focus -force .dia
	focus .dia.but
	#
	# Wait till they respond.	
	#
	tkwait variable but
	destroy .dia
	focus -force $oldfocus
}

proc HELP {} {
	#
	# Display the help text supplied. We don't want to try and display
	# more than one help screen at once. If the user attempts to do this
	# we will set the focus to the existing help screen.
	#
	if {[winfo exists .tklhelp]} {
		wm deiconify .tklhelp
		focus .tklhelp
		return
	}

	toplevel .tklhelp -class dialog
	frame .tklhelp.side -width 100 -height 300
	wm title .tklhelp "AltaVista Directory Load File Generator - Help"
	wm iconname .tklhelp "AltaVista Directory Load File Generator - Help"
	text .tklhelp.text -relief raised -bd 2 -yscrollcommand ".tklhelp.scroll set" -width 100 -height 50
	scrollbar .tklhelp.scroll -command ".tklhelp.text yview"
	button .tklhelp.but -text "OK" -command "set hbut 1" 
	pack .tklhelp.scroll -side right -fill y -in .tklhelp.side
	pack .tklhelp.text -side left -in .tklhelp.side
	pack .tklhelp.side .tklhelp.but -side top
	
	set f [open ..\\library\\readme.txt r]
	while {![eof $f]} {
		.tklhelp.text insert end [read $f 1000]
	}
	close $f
	tkwait variable hbut
	destroy .tklhelp
}
