#
# This is part of the AVD Conversion program for converting MS Exchange Server
# mailbox exported files into a Load Applet format for AVD.
#

source ..\\Library\\convproc.tcl

#
# Now change these terms to be the schema values that AVD supports -
# First the internal verions - those used by the AVD interface, these
# names should not be changed. Immediately after these is the external
# name, which is how you will probably know the name. For instance if we
# take "Last name" as known by the MS Exchange Server, this maps to SN in
# AVD. If your utility was to use "Family Name" instead you could either
# modify "Last name" to read "Family Name" or add a new internal and
# external name so that both "Last name" and "Family Name" are recognised.
#

#
# Note: any order changes/addition/subtractions made to these must but matched
# with the same changes in the internal list. As long as the relevant external
# value follows its internal value, and the cross reference of items is not
# changed then mapping will work. 
#
# This comparison is case sensitive and so could cause a problem in that regard.
# For example we have had to add "Last Name" and "Last name" as the two values
# do not match.
#

catch {unset internal}
catch {unset external}

lappend internal CN
lappend external Name
lappend internal CN
lappend external CommonName
lappend internal CN
lappend external Common
lappend internal CN
lappend external "Display Name"
lappend internal SN
lappend external "Last Name"
lappend internal SN
lappend external Surname
lappend internal SN
lappend external LastName
lappend internal SN
lappend external "Last name"
lappend internal AlternativeSurname
lappend external "Alternative Last Names"
lappend internal GivenName
lappend external "First Name"
lappend internal AlternativeGivenName
lappend external "Alternative First Names"
lappend internal GenerationalQualifier
lappend external Generation
lappend internal Title
lappend external "Job Title"
lappend internal Title
lappend external Title
lappend internal PersonalTitle
lappend external "Personal Title"
lappend internal UserPassword
lappend external Password
lappend internal Ou
lappend external "Organizational Unit"
lappend internal Ou
lappend external OrganizationalUnit
lappend internal Ou
lappend external Department

lappend internal telephoneNumber
lappend external "Work Phone"
lappend internal telephoneNumber
lappend external "Phone number"
lappend internal HomeTelephoneNumber
lappend external "Home Phone"
lappend internal HomeTelephoneNumber
lappend external "Home phone number"
lappend internal MobileTelephoneNumber
lappend external "Work Cellular"
lappend internal MobileTelephoneNumber
lappend external "Mobile number"
lappend internal HomeMobileTelephoneNumber 
lappend external "Home Cellular"
lappend internal FacsimileTelephoneNumber
lappend external "Work Fax"
lappend internal FacsimileTelephoneNumber
lappend external "Fax number"
lappend internal HomeFacsimileTelephoneNumber
lappend external "Home Fax"
lappend internal PagerTelephoneNumber
lappend external "Work Pager"
lappend internal PagerTelephoneNumber
lappend external "Pager number"
lappend internal HomePagerTelephoneNumber
lappend external "Home Pager"
lappend internal L
lappend external Location
lappend internal L
lappend external LocalityName
lappend internal L
lappend external Office
lappend internal PostalAddress
lappend external "Work Address"
lappend internal HomePostalAddress
lappend external "Home Address"
lappend internal O
lappend external Organization
lappend internal O
lappend external OrganizationName
lappend internal O
lappend external Company
lappend internal Manager
lappend external Manager 
lappend internal Secretary
lappend external Assistant
lappend internal SeeAlso
lappend external "See Also"
lappend internal Description
lappend external Notes
lappend internal Description
lappend external Description
lappend internal WorkLabeledURL
lappend external "Work Web Page"
lappend internal HomeLabeledURL
lappend external "Home Web Page"
lappend internal Rfc822Mailbox
lappend external "Work E-mail"
lappend internal Rfc822Mailbox
lappend external "E-mail Addresses"
lappend internal HomeRfc822Mailbox
lappend external "Home E-mail" 

lappend internal UserDef1
lappend external "Custom Attribute 1"
lappend internal UserDef1
lappend external "User 1"
lappend internal UserDef2
lappend external "Custom Attribute 2"
lappend internal UserDef2
lappend external "User 2"
lappend internal UserDef3
lappend external "Custom Attribute 3"
lappend internal UserDef3
lappend external "User 3"
lappend internal UserDef4
lappend external "Custom Attribute 4"
lappend internal UserDef4
lappend external "User 4"
lappend internal UserDef5
lappend external "Custom Attribute 5"
lappend internal UserDef5
lappend external "User 5"
lappend internal UserDef6
lappend external "Custom Attribute 6"
lappend internal UserDef6
lappend external "User 6"
lappend external Member
lappend internal Member
lappend external Owner
lappend internal Owner
lappend external "Name Qualifier"
lappend internal dnQualifier


#
# These enties are exclusive to MS Exchange Server and are not used by the
# AltaVista Directory. Do NOT modify these values, they are used inside this
# program.
#
lappend internal Obj-Class
lappend external "Obj-Class"
lappend internal Add1
lappend external Address
lappend internal Add2
lappend external City
lappend internal Add3
lappend external State
lappend internal Add4
lappend external "Postal code"
lappend internal Add5
lappend external Country


#
# Takes an input of either an internal and external name of an attr and returns 
# either the corresponding internal name or 0 to show it is invalid. 
#
proc make_internal i {
	#
	# Turn the input of an attribute name into the internal versions.
	# This then ensures that we know what we are doing in the AVDtcl area.
	#
	global internal external
    	if { [lsearch $internal $i] != -1} {
        	set attrs $i
    	} elseif { [lsearch -exact $external $i] != -1} { 
        	set attrs [lindex $internal [lsearch -exact $external $i]]
    	} else {
		set attrs 0
    	}
	return $attrs
}


proc avdconv {} {
  	global filein fileout
	global infile outfile

	set infile [ open $filein r]
	set outfile [ open $fileout w+] 

	#
	# Now read the first line of data so that we get the attribute types
	#
	set check 0
	while {$check == 0} {
        	set check [gets $infile read_attrs]
        	if {[string first "#" $read_attrs] == 0} {
            	set check 0
        	}
        	if {$check == -1} {
  			close $infile
			close $outfile
           	uplevel 0 {return "The data file is empty"}
        	}
	}



	#
	# Now make this line a list
	#
	set read_attrs [make_list_comma $read_attrs]

	set j 0
	set add1pos -1
	set add2pos -1
	set add3pos -1
	set add4pos -1
	set add5pos -1
	set objpos -1
	set mailpos -1

	#
	# Now we must make that list internal values so that we can use it.
	#
	foreach i $read_attrs {
		set value [make_internal $i]
		if {$value == 0} {
			close $infile
			close $outfile
			uplevel 0 {return "Invalid attribute name\n please check input files"}
		}  
		lappend attrs $value
		#
		# We are dealing with the heading names here.
		# This section looks for the attributes which require special processing and records
		# which columns they are in so that the attribute values can be identified later.
		#
		if {[string compare $value "Add1"] == 0} {
			set add1pos $j
		} elseif {[string compare $value "Add2"] == 0} {
			set add2pos $j
		} elseif {[string compare $value "Add3"] == 0} {
			set add3pos $j
		} elseif {[string compare $value "Add4"] == 0} {
			set add4pos $j
		} elseif {[string compare $value "Add5"] == 0} {
			set add5pos $j
		} elseif {[string compare $value "Obj-Class"] == 0} {
			set objpos $j
		} elseif {[string compare $value "Rfc822Mailbox"] == 0} {
			set mailpos $j
			set newhead [lappend newhead $value]
		} else {
			set newhead [lappend newhead $value]
		}
		incr j
	}

	#
	# Check to ensure the mandatory columns are in the table.
	#
	if {[lsearch $attrs CN] == -1} {
		close $infile
		close $outfile
		uplevel 0 {return "Invalid table - no Name column"}
	}
	if {[lsearch $attrs SN] == -1} {
		close $infile
		close $outfile
		uplevel 0 {return "Invalid table - no Last Name column"}
	}

	# We will append the Address to the end of the list. If we decided to place it into the
	# Add1 position (say) and Add1 wasn't in the column headings we would have problems. This
	# way we don't have to worry if any of the address fields are missing.
	#
	# An address will be appended to the list if any one (or more) of the five parts of the
	# address attributes exist.
	#
	if {(($add1pos != -1) || ($add2pos != -1) || ($add3pos != -1) || ($add4pos != -1) || ($add5pos != -1))} {
		set newhead [lappend newhead "PostalAddress"]
	}

	#
	# avdload expects tab separators rather than spaces, so convert, and then write
	# the headings to the output file.
	#
	set newhead [space_to_tab $newhead]
	puts $outfile $newhead


	#
	# We have finished with the headings now and are starting to look at the data beneath them,
	# so we will loop around reading all the lines from the table and translating them into a
	# format that avdload will understand
	#
	while {[gets $infile inline] != -1} {
		#
		# Don't do anything with lines starting with comments and the blank lines.
		#
        if {[string first "#" $inline] != 0 && [string length $inline] != 0 } {
			#
			# Convert the line into a list
			#
			set line [make_input_list $inline]

        	#
        	# Check that it has the correct number of attributes
        	#         
        	if {[llength $line] > [llength $attrs]} { 
				puts $outfile ""
           		puts $outfile "# Too many columns in line (more columns than headings)"
           		puts $outfile $inline
        	} elseif {[string first "#" $attrs] != 0} {
				#
				# Clear out the variables so that they are fresh before starting the loop.
				#
        		set i 0
				set add1 ""
				set add2 ""
				set add3 ""
				set add4 ""
				set add5 ""
				set mailaddr ""
				set persline ""

				set length [llength $attrs]
        		while {$i < $length} {
           			#
          			# Attribute formating to remove any quotes around the string
           			#
					set value [lindex $line $i]
					set attrib [remove_brace $value]
					if {$i == $add1pos} {
						set add1 $attrib
					} elseif {$i == $add2pos} {
						set add2 $attrib
					} elseif {$i == $add3pos} {
						set add3 $attrib
					} elseif {$i == $add4pos} {
						set add4 $attrib
					} elseif {$i == $add5pos} {
						set add5 $attrib
					} elseif {$i == $objpos} {
						# This line is not used by AVD, but check it has "Mailbox" value
						if {[string compare $attrib "Mailbox"] != 0} {
							puts $outfile ""
							puts $outfile "# This entry is not of mailbox type"
						}
					} elseif {$i == $mailpos} {
						set mailaddr [get_mail_val $attrib]
						set persline [lappend persline $mailaddr]
					} else {
						set persline [lappend persline $attrib\t]
					}
 					incr i 1
					unset value
				}

				# Split the test over an if, elseif as it didn't fit on one line!
				if {[string length $add2] > 30 || [string length $add3] > 30} {
					puts $outfile ""
					puts $outfile "# Longest PostalAddress is 6 lines of no more than 30 chars, $ is newline char"
				} elseif {[string length $add4] > 30 || [string length $add5] > 30} {
					puts $outfile ""
					puts $outfile "# Longest PostalAddress is 6 lines of no more than 30 chars, $ is newline char"
				}

				#
				# Due to a AHS hardcoding of the address field format we have to specify the address
				# as being no more than 6 lines of 30 chars. The AHS delimits the end of each line
				# with a $, which accounts for why one is added between each part below.
				#
				# We need to take add1 which is a list, break it down into it's separate elements
				# which will be strings as we will make sure that any lists inside are removed before
				# starting. We then process each char in the string one at a time to see if it is a
				# \n. A \n is replaced by a space " " unless it is the first one, in which case it
				# is replaced by a dollar "$" which is what AHS understands as a newline. We can let
				# one newline through as we have six lines to play with and only five elements to
				# make them up. Each element would normally take up one line. The first element is
				# the only one which should contain a \n.

				set add1 [sort_out_newline $add1]

				#
				# if some of the elements in the mail address are missing, we cannot
				# specify $$$$ or even $$Reading$Berkshire,$U.K. so we cannot do the following
				#
				# set PAddress "$add1\$$add2\$$add3\$$add4\$$add5"
				#
				# until we set empty strings to be just one space. This way we will maintain the
				# positioning of the separate elements if any are missed out.
				#	
				if {[string compare $add1 ""] == 0} {
					set add1 " "
				}
				if {[string compare $add2 ""] == 0} {
					set add2 " "
				}
				if {[string compare $add3 ""] == 0} {
					set add3 " "
				}
				if {[string compare $add4 ""] == 0} {
					set add4 " "
				}
				if {[string compare $add5 ""] == 0} {
					set add5 " "
				}

				set PAddress "$add1\$$add2\$$add3\$$add4\$$add5"

				regsub -all : $PAddress " " PAddress

				set persline [lappend persline $PAddress]
				set persline [remove_brace $persline]

				# Write the output to the output file
				puts $outfile $persline
			}
		}
	}

	#
	# Now just clearup after the completion
	#
	flush $outfile
	close $outfile

	return 1
}















